/*
 * Created on Aug 12, 2003
 */
package DatabaseCommunication;

import java.sql.*;
import java.util.*;
import Data.AnnouncementData;

/**
 * @author student
 * This class manages communication of Announcement data with application database.
 * 
 */
public class AnnouncementManager {
	DatabaseConnection dbcon = new DatabaseConnection();

	/**
	 * This is the constructor for AnnouncementManager.java
	 */
	public AnnouncementManager() {
	}

	/**
	 * This method is being used to select all the announcement in an order.
	 * @throws Exception 
	 * @return AnnouncementData[] array of selected announcements.
	 */
	public AnnouncementData[] selectAllAnnouncements() throws Exception {

		//				dbcon.executeSelect("SORT announcement;");
		ResultSet rs =
			dbcon.executeSelect(
				"SELECT * FROM announcement ORDER BY expiryTime DESC;");
		AnnouncementData[] announcementArray = new AnnouncementData[10];
		for (int i = 0; rs.next(); i++) {
			if (rs
				.getTimestamp("expiryTime")
				.after(new Timestamp(System.currentTimeMillis()))) {
				AnnouncementData announcement =
					new AnnouncementData(
						stripTrailing(rs.getString("fromUser")),
						stripTrailing(rs.getString("body")),
						stripTrailing(rs.getString("subject")),
						rs.getTimestamp("time"));
				announcementArray[i] = announcement;
			}
		}
		return announcementArray;
	}

//	/**
//	 * This method is being used select 
//	 * @param time
//	 * @return
//	 * @throws Exception AnnouncementData
//	 */
//	public AnnouncementData selectUser(String time) throws Exception {
//		ResultSet rs =
//			dbcon.executeSelect(
//				"SELECT * FROM announcement WHERE announcement.time = '"
//					+ time
//					+ "'");
//
//		if (rs.next()) {
//			return new AnnouncementData(
//				stripTrailing(rs.getString("from")),
//				stripTrailing(rs.getString("body")),
//				stripTrailing(rs.getString("subject")),
//				rs.getTimestamp("time"));
//		}
//		return null;
//
//	}

	/**
	 * This method is being used for stripping trailing blanks
	 * @param value String to strip blanks from
	 * @return String Stripped string
	 */
	public String stripTrailing(String value)
	// strip trailing blanks...
	{
		if (value == null)
			return "";

		char cs[] = value.toCharArray();

		int end = cs.length;
		while (end > 0 && cs[end - 1] == ' ')
			end--;

		return new String(cs, 0, end);
	}

	/**
	 * This method is being used to insert announcement 
	 * @param data Announcement data to be inserted
	 * @throws Exception void
	 */
	public void insertAnnouncementData(Data.AnnouncementData data)
		throws Exception {

		dbcon.execute(
			"INSERT INTO announcement (fromUser,body,subject,time,expiryTime) VALUES ("
				+ "'"
				+ data.getFrom()
				+ "',"
				+ "'"
				+ data.getBody()
				+ "',"
				+ "'"
				+ data.getSubject()
				+ "',"
				+ "'"
				+ data.getTime()
				+ "',"
				+ "'"
				+ calculateExpiry(data.getTime())
				+ "');");

	}

	/**
	 * This method is being used to update announcement .
	 * @param data Announcement data to be updated.
	 * @throws Exception void
	 */
	public void updateAnnouncementData(AnnouncementData data)
		throws Exception {
		dbcon.execute(
			"UPDATE announcement SET "
				+ " from = '"
				+ data.getFrom()
				+ "',"
				+ " body = '"
				+ data.getBody()
				+ "',"
				+ " subject = '"
				+ data.getSubject()
				+ "',"
				+ " time = '"
				+ data.getTime()
				+ "',"
				+ " expiryTime = '"
				+ calculateExpiry(data.getTime())
				+ "',");

	}

	/**
	 * This method is being used to delete announcement
	 * @param data Announcemenet data to be deleted.
	 * @throws Exception void
	 */
	public void deleteUserData(Data.AnnouncementData data) throws Exception {
		dbcon.execute(
			"DELETE FROM announcement WHERE time = '" + data.getTime() + "'");
	}
	/**
	 * This method is being used to calculate expiry of the announcement data.
	 * @param fromTime Time the announcement was created
	 * @return Timestamp expiry time
	 */
	private Timestamp calculateExpiry(Timestamp fromTime) {
		if (fromTime != null) {
			long expiry = addDays(fromTime, 1);
			Timestamp expiryTime = new Timestamp(expiry);
			return expiryTime;
		}
		return null;
	}
	/**
	 * This method is being used to add days 
	 * @param startDate 
	 * @param numberOfDays
	 * @return long
	 */
	public static long addDays(java.util.Date startDate, int numberOfDays) {
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(startDate);
		cal.add(Calendar.DATE, numberOfDays);
		return cal.getTimeInMillis();

	}
}
